// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "vertexVersionSimple.h"

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"

attribute mediump vec4 POSITION;
attribute vec4 COLOR;

varying vec4 color;

varying highp vec3 pos;

const float fogNear = 0.3;

void main()
{ vec4 p = POSITION;
p.y -= max(-1.9 , length(p.xyz))*0.36;
    gl_Position = WORLDVIEWPROJ * p;

//gl_Position.yz -= max(1.9, length(gl_Position.xy)*1.9)*1.9;

pos = POSITION.xyz;

    color = mix( CURRENT_COLOR, FOG_COLOR, COLOR.r );
}
